﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
''' 单个客户
''' </summary>
Public Class Customer

    ''' <summary>
    ''' 创建一个新客户
    ''' </summary>
    ''' <param name="customerId">唯一标识客户的 ID</param>
    ''' <param name="companyName">此客户的姓名</param>
    ''' <param name="city">此客户所在的城市</param>
    ''' <param name="region">此客户所在的地区</param>
    ''' <param name="country">此客户所在的国家</param>
    Public Sub New(ByVal customerId As String, ByVal companyName As String, ByVal city As String, ByVal region As String, ByVal country As String)
        Initialize()
        customerIDValue = customerId
        companyNameValue = companyName
        cityValue = city
        regionValue = region
        countryValue = country
    End Sub

    Private Sub Initialize()
        ordersValue = New Orders()
    End Sub

    Private customerIDValue As String
    ''' <summary>
    ''' 客户的标识符
    ''' </summary>
    Public Property CustomerID() As String
        Get
            Return customerIDValue
        End Get
        Set(ByVal value As String)
            customerIDValue = value
        End Set
    End Property

    Private companyNameValue As String
    ''' <summary>
    ''' 此客户的姓名
    ''' </summary>
    Public Property CompanyName() As String
        Get
            Return companyNameValue
        End Get
        Set(ByVal Value As String)
            companyNameValue = Value
        End Set
    End Property


    Private cityValue As String
    ''' <summary>
    ''' 此客户所在的城市
    ''' </summary>
    Public Property City() As String
        Get
            Return cityValue
        End Get
        Set(ByVal Value As String)
            cityValue = Value
        End Set
    End Property

    Private regionValue As String
    ''' <summary>
    ''' 此客户所在的地区
    ''' </summary>
    Public Property Region() As String
        Get
            Return regionValue
        End Get
        Set(ByVal Value As String)
            regionValue = Value
        End Set
    End Property

    Private countryValue As String
    ''' <summary>
    ''' 此客户所在的国家
    ''' </summary>
    Public Property Country() As String
        Get
            Return countryValue
        End Get
        Set(ByVal Value As String)
            countryValue = Value
        End Set
    End Property

    Private WithEvents ordersValue As Orders
    ''' <summary>
    ''' 此客户的订单
    ''' </summary>
    Public Property Orders() As Orders
        Get
            Return ordersValue
        End Get
        Set(ByVal value As Orders)
            ordersValue = value
        End Set
    End Property

    Private Sub ordersValue_AddingNew(ByVal sender As Object, ByVal e As System.ComponentModel.AddingNewEventArgs) Handles ordersValue.AddingNew
        e.NewObject = New Order(999, Me.CustomerID, Date.Today, DateAdd(DateInterval.Day, 30, Date.Today))
    End Sub
End Class

''' <summary>
''' Customers 集合
''' </summary>
Public Class Customers
    Inherits System.ComponentModel.BindingList(Of Customer)
End Class